#include <stdio.h>
#include <assert.h>
#include <stddef.h>
#include <time.h>
#include <string.h>

#include "common_util.h"

#include "date_time_util.h"

enum {
    SEL_CUR_DATE,
    SEL_CUR_TIME
};

/*
 * Date as "DD MMMM YYYY"
 * Ex: " 1 Sept 2025" or "17 Nov 2025"
 *
 * Important! Update CUR_DATE_MAX_SZ if this format changes!
 */
#define CUR_DATE_FMT "%e %b %Y"

/*
 * Time as "HH:MM"
 * Ex: "07:42" or "14:30"
 *
 * Important! Update CUR_TIME_MAX_SZ if this format changes!
 */
#define CUR_TIME_FMT "%H:%M"

static void get_cur_datetime_str(char *result, size_t max_sz, int date_or_time);

void get_cur_date(char *result, size_t max_sz) {
    get_cur_datetime_str(result, max_sz, SEL_CUR_DATE);
}

void get_cur_time(char *result, size_t max_sz) {
    get_cur_datetime_str(result, max_sz, SEL_CUR_TIME);
}

static void get_cur_datetime_str(char *result, size_t max_sz, int date_or_time) {
    char *selected_fmt;
    int selected_max_sz;
    time_t cur_time;
    struct tm cur_tm;
    struct tm *cur_tm_result;

    if (date_or_time == SEL_CUR_DATE) {
        selected_fmt = CUR_DATE_FMT;
        selected_max_sz = CUR_DATE_MAX_SZ;
    }
    else {
        selected_fmt = CUR_TIME_FMT;
        selected_max_sz = CUR_TIME_MAX_SZ;
    }

    assert(max_sz <= selected_max_sz);

    memset(result, '\0', max_sz);
    memset(&cur_tm, '\0', sizeof(cur_tm));

    cur_time = time(NULL);
    assert_not_null(cur_tm_result = localtime_r(&cur_time, &cur_tm));
    strftime(result, max_sz - 1, selected_fmt, cur_tm_result);
}
